File: /adapters/cursor/prompt-pack-basic.md

# Prompt Pack — Basic (Free Edition)

This file contains safe prompt patterns for SaaS OS Free Edition.

Free Edition supports:

- Button contract
- Input contract
- Token-aligned styling
- Single-file generation

It does NOT support:

- Multi-page orchestration
- Flow-driven generation
- Structural refactors
- Advanced automation pipelines

---

## 1) Generate a Button Component

Use this pattern when creating or updating a Button.

Example:

Read:
- SaaS-OS-Free-v1.0/docs/engineering/contracts/Contract — ui-button.md

Modify:
- components/ui-button.tsx

Rules:
- Follow the contract exactly.
- Do not add new props or variants.
- Use SaaS OS token variables only.
- Do not invent behavior.
- Do not introduce implicit state.

If any requirement is unclear, STOP and ask.

---

## 2) Generate an Input Component

Read:
- SaaS-OS-Free-v1.0/docs/engineering/contracts/Contract — ui-input.md

Modify:
- components/ui-input.tsx

Rules:
- Follow the contract exactly.
- Do not invent validation logic.
- Do not add implicit behavior.
- Use SaaS OS tokens only.
- Preserve semantic HTML.

If a requirement is missing, STOP.

---

## 3) Generate a Simple Landing Page

Read:
- Button contract
- Input contract

Modify:
- app/page.tsx

Rules:
- Use SaaS OS token variables.
- Include one primary Button.
- Include one Input field.
- Do not invent additional states.
- Do not introduce backend logic.

Keep layout simple and explicit.

---

## Important Reminder

Contracts define meaning.

Cursor executes instructions.

If a prompt conflicts with a contract:

The contract wins.